#ifndef GUA_H
#define GUA_H

#define MIN_GUA 1
#define MAX_GUA 8

#include <boost/array.hpp>
#include <string>
#include <bitset>

class Gua
{
	public:
		Gua(size_t n, std::string name, std::bitset<3> compose,
			std::string wuXing,std::string view,
			boost::array<std::string,3> upGanZhi, boost::array<std::string,3> downGanZhi);
		size_t getN() { return _n; };
		std::string getName() { return _name; };
		std::bitset<3> getCompose() { return _compose; };
		std::string getWuXing() { return _wuXing; };
		std::string getView() { return _view; };
		boost::array<std::string,3> getUpGanZhi() { return _upGanZhi; };
		boost::array<std::string,3> getDownGanZhi() { return _downGanZhi; };
	protected:
	private:	
		size_t _n;					///< Ѩ
		std::string _name;
		std::bitset<3> _compose;
		std::string _wuXing;
		std::string _view;
		boost::array<std::string,3> _upGanZhi;
		boost::array<std::string,3> _downGanZhi;
};

#endif
