/** 
 *  @file z@ 
 */
#include "GanZhi.h"

/**
 * @fn GanZhi::GanZhi(WGan gan, WZhi zhi)
 *
 * @brief   GanZhiOConstructorAHmember initialization listlƸ
 * 
 * @param gan	QѤz
 * @param zhi	QGa䪫
 * 
 * @return (SǦ^)
 */
GanZhi::GanZhi(WGan gan, WZhi zhi):_gan(gan), _zhi(zhi)
{}

/**
 * @fn size_t GanZhi::getN(std::string name)
 * @brief oz䪺QҤlǸ 
 * 
 * @param name zW
 * 
 * @return QҤlǸ
 */

size_t GanZhi::getN(std::string name)
{	
	size_t ganN = _gan.getGan(name.substr(0,1)).getN();
	size_t zhiN = _zhi.getZhi(name.substr(1,1)).getN();

	size_t serial = 6 * ganN - 5 * zhiN;
	if (serial <= 0)
		serial += 60;

	return serial;
}

/**
 * @fn std::string GanZhi::getName(size_t serial)
 * @brief ѤQҤlǸozW 
 * 
 * @param serial QҤlǸ
 * 
 * @return zW
 */

std::string GanZhi::getName(size_t serial)
{
	size_t ganN = (serial % 10 == 0)? 10 : serial % 10;
	size_t zhiN = (serial % 12 == 0)? 12 : serial % 12;
	
	std::string gName = std::string(_gan.getGan(ganN).getName());
	std::string zName = std::string(_zhi.getZhi(zhiN).getName());
	
	return gName + zName;	
}

/**
 * @fn size_t GanZhi::getDiffer(std::string)
 * @brief oz䤤zmPmtZ 
 * 
 * @param name zW
 * 
 * @return zmPmtZ
 */
size_t GanZhi::getDiffer(std::string name)
{
	int ganN = static_cast<int>(_gan.getGan(name.substr(0,1)).getN());
	int zhiN = static_cast<int>(_zhi.getZhi(name.substr(1,1)).getN());

	int subtract = zhiN - ganN;
	if(subtract < 0 )
		subtract = zhiN + 12 - ganN;

	return subtract;
}

/**
 * @fn std::string GanZhi::getNothing(std::string name)
 * @brief ozݦ(Ť`) 
 * 
 * @param name zW
 * 
 * @return Ťz
 */
std::string GanZhi::getNothing(std::string name)
{
	std::string nothing[] = {"","l","Gf","x","ȥ","Ө"};

	size_t subtract = getDiffer(name);

	return nothing[subtract/2];	
}