#ifndef CTIME_H
#define CTIME_H

#include <map>
#include "boost/date_time/posix_time/posix_time.hpp"
#include "boost/date_time/gregorian/gregorian.hpp"
#include "GanZhi.h"
#include "help.h"

//using namespace boost::posix_time;		///< ĮɶAD1400-10000
//using namespace boost::gregorian;

typedef struct _ctm
{
	long long accumulate;
	std::string ganZhi;
} ctm;


class CTime
{
	typedef std::map<std::string,std::string> nsnsMap;
	public:
		CTime(GanZhi wgz);
		void init();
		boost::posix_time::ptime getNow() { return _now; };
		nsnsMap getYearMap() { return _year; };
		nsnsMap getMonthMap() { return _month; };
		nsnsMap getDayMap() { return _day; };
		nsnsMap getHourMap() { return _hour; };
		std::map<std::string,boost::posix_time::ptime> getAfterJieQi(boost::posix_time::ptime inTime);
	protected:
	private:		
		GanZhi _wgz;
		boost::posix_time::ptime _now;
		
		nsnsMap _year;
		nsnsMap _month;
		nsnsMap _day;
		nsnsMap _hour;

		typedef std::map<std::string,boost::posix_time::ptime> nsPtimeMap;
		nsPtimeMap _thisYearJieQi;
		nsPtimeMap _lastYearJieQi;

		void setYearAccN();
		void setMonthAccN();
		void setDayAccN();
		void setHourAccN();

		void setYearGanZhi();
		void setMonthGanZhi();
		void setDayGanZhi();
		void setHourGanZhi();

		void setThisYearJieQi();
		void setLastYearJieQi();

		long getDifferWinterSolstice();		

		int getJiR(double accN);

		int getYinLiMonth();
};

#endif
