/** 
 *  @file ǲήɶ@
 */
#include "CTime.h"

#define BASENUM 10153917
#define YEARLENGTH 365.2425
#define JI 60

 /**
 * @fn CTime::CTime(GanZhi wgz)
 * @brief  CTimeOConstructorAHmember initialization listlƸ
 * 
 * @param wgz z䪫
 * 
 * @return Ǧ^CTime
 */
CTime::CTime(GanZhi wgz) : _wgz(wgz)
{	
	using boost::posix_time::ptime;
	using boost::posix_time::second_clock;
	(*this)._now = ptime(second_clock::local_time()); //use the clock
}

/**
 * @fn void CTime::init()
 * @brief  ]wUlƭ
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::init()
{
	setThisYearJieQi();
	setLastYearJieQi();
	setYearAccN();
	setMonthAccN();
	setDayAccN();
	setHourAccN();
	getDifferWinterSolstice();

	setYearGanZhi();
	setMonthGanZhi();
	setDayGanZhi();
	setHourGanZhi();
}

/**
 * @fn void CTime::setYearAccN()
 * @brief  ]w~n
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setYearAccN()
{
	char buf[10];
	itoa(BASENUM + static_cast<unsigned short>(_now.date().year()),buf, 10);	
	
	_year["n"] = std::string(buf);
	//std::cout << "~n = " << _year["n"] << std::endl;
}

/**
 * @fn void CTime::setMonthAccN()
 * @brief  ]wn
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setMonthAccN()
{
	char buf[12];
	itoa((atoi(_year["n"].c_str()) - 1) * 12 + getYinLiMonth(), buf, 10) ;

	_month["n"] = std::string(buf);
	//std::cout << "n = " << _month["n"] << std::endl;
}

/**
 * @fn void CTime::setDayAccN()
 * @brief  ]wn
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setDayAccN()
{		
	using boost::gregorian::gregorian_calendar;	
	
	double accDayOfYear = floor(atoi(_year["n"].c_str()) * YEARLENGTH);	
	double accDayOfLastYear = floor((atoi(_year["n"].c_str()) - 1) * YEARLENGTH);
	int distance =  accDayOfYear - accDayOfLastYear;	

	bool leap = gregorian_calendar::is_leap_year(_now.date().year());

	if (leap == false && distance == 366)
		accDayOfYear -= 1;

	double accDay = accDayOfYear + getDifferWinterSolstice() + 150;	
	
	char buf[_CVTBUFSIZE];
	gcvt(accDay, ceil((double)log10((double)accDay)), buf);		

	if (buf != NULL)
		_day["n"] = std::string(buf);

	//std::cout << "n = " << _day["n"] << std::endl;
}

/**
 * @fn void CTime::setHourAccN()
 * @brief  ]wɿn
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setHourAccN()
{
	const char *str = _day["n"].c_str();
	char *stopStr;
	double accDay = strtod(str, &stopStr);
	double accHour = 0;

	// L23ɧY
	if (_now.time_of_day().hours() == 23)
		accHour = accDay * 12 +1;
	else
		accHour = (accDay - 1) * 12 + ceil((float)_now.time_of_day().hours()/2) + 1;

	char buf[_CVTBUFSIZE];
	gcvt(accHour, ceil((double)log10((double)accHour)), buf);	
	
	if (buf != NULL)
		_hour["n"] = std::string(buf);	

	//std::cout << "ɿn = " << _hour["n"] << std::endl;
}

/**
 * @fn void CTime::setYearGanZhi()
 * @brief  ]w~z
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setYearGanZhi()
{
	_year["z"] = _wgz.getName(getJiR(atoi(_year["n"].c_str())));
	//std::cout << "~z = " << _year["z"] << std::endl;
}

/**
 * @fn void CTime::setMonthGanZhi()
 * @brief  ]wz
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setMonthGanZhi()
{
	_month["z"] = _wgz.getName(getJiR(atoi(_month["n"].c_str())));
	//std::cout << "z = " << _month["z"] << std::endl;
}

/**
 * @fn void CTime::setDayGanZhi()
 * @brief  ]wz
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setDayGanZhi()
{
	const char *str = _day["n"].c_str();
	char *stopStr;
	double accDay = strtod(str, &stopStr);

	_day["z"] = _wgz.getName(getJiR(accDay));
	//std::cout << "z = " << _day["z"] << std::endl;
}

/**
 * @fn void CTime::setHourGanZhi()
 * @brief  ]wɤz
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setHourGanZhi()
{
	const char *str = _hour["n"].c_str();
	char *stopStr;
	double accHour = strtod(str, &stopStr);
	
	_hour["z"] = _wgz.getName(getJiR(accHour));
	//std::cout << "ɤz = " << _hour["z"] << std::endl;
}

/**
 * @fn void CTime::setThisYearJieQi()
 * @brief  ]w~`ɶ
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */
void CTime::setThisYearJieQi()
{	
	char buf[6];
	itoa(static_cast<unsigned short>(_now.date().year()),buf,10);
	std::string thisYear(buf);
	std::string suffix(".txt");

	//std::cout << thisYear + suffix << std::endl;

	_thisYearJieQi = getJieQiFromFile(thisYear + suffix);		
}

/**
 * @fn void CTime::setLastYearJieQi()
 * @brief  ]wh~`ɶ
 * 
 * @param (SѼ)
 * 
 * @return (SǦ^)
 */

void CTime::setLastYearJieQi()
{
	char buf[6];
	itoa(static_cast<unsigned short>(_now.date().year() - 1),buf,10);
	std::string lastYear(buf);
	std::string suffix(".txt");
	
	//std::cout << lastYear + suffix << std::endl;

	_lastYearJieQi = getJieQiFromFile(lastYear + suffix);
}

 /** 
 * @fn long CTime::getDifferWinterSolstice()
 * @brief DPVܤ۶ZѼ
 * 
 * @return PVܮtZѼ
 * @sa http://www.boost.org/doc/html/date_time/examples.html#date_time.examples.days_alive
 */
long CTime::getDifferWinterSolstice()
{	
	using boost::gregorian::date;
	using boost::gregorian::days;

	date today = _now.date();
	date thisYearWinterSolstice = _thisYearJieQi["V"].date();
	date lastYearWinterSolstice = _lastYearJieQi["V"].date();
	
	days differ = today - thisYearWinterSolstice;
	if (differ.days() < 0)
		differ = today - lastYearWinterSolstice;

	/*
	std::cout << "today = " << today <<  std::endl;
	std::cout << "lastYearWinterSolstice = " << _lastYearJieQi["V"] << std::endl;
	std::cout << "differ = " << differ.days() << std::endl;
	*/

	return differ.days();
}

/**
 * @fn std::map<std::string,boost::posix_time::ptime> CTime::getAfterJieQi(boost::posix_time::ptime inTime)
 * @brief  oҭp⪺ɶb@Ӹ`𤧫
 * 
 * @param inTime np⪺ɶ
 * 
 * @return Ǧ^`WٻPɶMap
 */
std::map<std::string,boost::posix_time::ptime> CTime::getAfterJieQi(boost::posix_time::ptime inTime)
{
	using boost::posix_time::ptime;
	
	std::map<std::string,ptime> jieQiMap, thisYearJieQiMap, lastYearJieQiMap;
	
	char buf[6];	
	std::string suffix(".txt");	
	
	// o~`
	itoa(static_cast<unsigned short>(inTime.date().year()),buf,10);
	std::string inYear(buf);	
	thisYearJieQiMap = getJieQiFromFile( inYear + suffix);

	// oh~`
	itoa(static_cast<unsigned short>(inTime.date().year() - 1),buf,10);		
	std::string inLastYear(buf);
	lastYearJieQiMap = getJieQiFromFile( inLastYear + suffix);
	
	std::string lastMatch;
	boost::array<std::string, 24> jieQi =	{"pH","jH","߬K","B",
											 "h","K","M","\B",
											 "߮L","p","~","L",
											 "p","j","߬","B",
											 "S","","HS","",
											 "ߥV","p","j","V"};
	for (size_t i = 0; i < 24; i++)
	{
		if (inTime >= thisYearJieQiMap[jieQi[i]])
			lastMatch = jieQi[i];
	}

	if (lastMatch.size() == 0)
		jieQiMap["V"] = lastYearJieQiMap["V"]; //W@~V
	else
		jieQiMap[lastMatch] = thisYearJieQiMap[lastMatch];	

	return jieQiMap;
}

/**
 * @fn int CTime::getYinLiMonth()
 * @brief  o
 * 
 * @param (SѼ)
 * 
 * @return Ǧ^
 */
int CTime::getYinLiMonth()
{
	// ()l(=A11)_ۤjAH"`"}l
	boost::array<std::string, 24> jieQiMonth = {"j","V","pH","jH",
												"߬K","B","h","K",
												"M","\B","߮L","p",
	   	   	   		   	   						"~","L","p","j",
	   	   	   		   	   						"߬","B","S","",
												"HS","","ߥV","p"};
	std::map<std::string, boost::posix_time::ptime> theJieQi = getAfterJieQi(_now);

	int yinLiMonth = 0;
	for(size_t i = 0; i < jieQiMonth.size(); i++)
	{
		if (theJieQi.begin()->first == jieQiMonth.at(i))
			yinLiMonth = i / 2 + 1;
	}
	
	return yinLiMonth;
}

/**
 * @fn int CTime::getJiR(double accN)
 * @brief  qnƨo(1 = 60)l
 * 
 * @param accN p⪺n
 * 
 * @return l
 */
int CTime::getJiR(double accN)
{
	return static_cast<int>(fmod(accN , JI));
}