#ifndef BASEYIGUA_H
#define BASEYIGUA_H

#include <iostream>
#include <string>
#include <bitset>
#include <map>
#include <vector>
#include <algorithm>

#include "BaGua.h"
#include "WWuXing.h"
#include "WGan.h"
#include "WZhi.h"

class BaseYiGua
{
	public:
		BaseYiGua(Gua downGua, Gua upGua,
			size_t n, std::string name,
			std::string belongToGua, size_t guaN);
		Gua getUpGua() { return _upGua; };
		Gua getDownGua() { return _downGua; };
		std::string getName() {return _name; };
		std::string getBelongToGua() { return _belongToGua; };
		size_t getGuaN() { return _guaN; };
		void setVarYao(std::vector<size_t> yao);
		std::bitset<6> getCompose();
		boost::array<size_t, 2> getShiYing();
		std::string getShiName();
		std::string getKin(WuXing lc, WuXing rc);
		boost::array<std::string,6> getSixKin(Gua upGua, Gua downGua);
		boost::array<std::string, 6> getSixBeast(Gan dayGan);
		std::vector<std::string> getHideGod();
	private:
		Gua _downGua;		
		Gua _upGua;		
		size_t _n;
		std::string _name;
		std::string _belongToGua;
		size_t _guaN;
};

#endif
