#include "BaseYiGua.h"

/**
 * @fn BaseYiGua::BaseYiGua(Gua downGua, Gua upGua,
 *					   size_t n, std::string name,
 *					   std::string belongToGua, size_t guaN)
 * @brief    BaseYiGuaOConstructorAHmember initialization listlƸ
 * 
 * @param downGua		U
 * @param upGua			W
 * @param n				
 * @param name			W
 * @param belongToGua	ݩc
 * @param guaN			cUǸ
 * 
 * @return 
 */
BaseYiGua::BaseYiGua(Gua downGua, Gua upGua,
					   size_t n, std::string name,
					   std::string belongToGua, size_t guaN):
	_downGua(downGua),_upGua(upGua),
	_n(n), _name(name),
	_belongToGua(belongToGua), _guaN(guaN)
{}

/**
 * @fn void BaseYiGua::setVarYao(std::vector<size_t> yao)
 * @brief  ܤ쪺AA|Ϩoܤ
 * 
 * @param yao nܪm(0-5)
 * 
 * @return (SǦ^)
 */
void BaseYiGua::setVarYao(std::vector<size_t> yao)
{
	BaGua gua8 = BaGua::initBaGua();	

	std::sort(yao.begin(),yao.end());
	std::bitset<3> compose;

	for(size_t i = 0; i < yao.size(); i++)
	{
		if (yao.at(i) > 3)		/// W
		{
			compose = _upGua.getCompose();
			_upGua = gua8.getGua(compose.flip(yao.at(i)-3));
		}
		else					/// U
		{
			compose = _downGua.getCompose();
			_downGua = gua8.getGua(compose.flip(yao.at(i)));
		}
	}
}

/**
 * @fn std::bitset<6> BaseYiGua::getCompose()
 * @brief  oӤ쪺A
 * 
 * @param (SѼ)
 * 
 * @return Ǧ^Ӧ줸
 */
std::bitset<6> BaseYiGua::getCompose()
{
	std::string upGua = _upGua.getCompose().to_string();
	std::string downGua = _downGua.getCompose().to_string();

	std::bitset<6> compose(upGua + downGua);

	return compose;
}

/**
 * @fn boost::array<size_t, 2> BaseYiGua::getShiYing()
 * @brief  o@Ҧb(1-6)
 * 
 * @param (SѼ)
 * 
 * @return Ǧ^"@"B""Ҧb쪺}C
 */
boost::array<size_t, 2> BaseYiGua::getShiYing()
{
	boost::array<size_t, 2> shiYing;	///< ઽbcaselƼƭ

	switch(_guaN)
	{
		case 0:		///< c
			shiYing.at(0) = 6;		///< @Ҧb
			shiYing.at(1) = 3;		///< Ҧb
			break;
		case 1:		///< @@
			shiYing.at(0) = 1;
			shiYing.at(1) = 4;
			break;
		case 2:		///< G@
			shiYing.at(0) = 2;
			shiYing.at(1) = 5;
			break;
		case 3:		///< T@
			shiYing.at(0) = 3;
			shiYing.at(1) = 6;
			break;
		case 4:		///< |@
			shiYing.at(0) = 4;
			shiYing.at(1) = 1;
			break;
		case 5:		///< @
			shiYing.at(0) = 5;
			shiYing.at(1) = 2;
			break;
		case 6:		///< C
			shiYing.at(0) = 4;
			shiYing.at(1) = 1;
			break;
		case 7:		///< k
			shiYing.at(0) = 3;
			shiYing.at(1) = 6;
			break;		
		default:
			break;
	}
	return shiYing;
}

/**
 * @fn std::string BaseYiGua::getShiName()
 * @brief  oH"@"DW
 * 
 * @param (SѼ)
 * 
 * @return Ǧ^@W
 */
std::string BaseYiGua::getShiName()
{
	switch(_guaN)
	{
		case 0:	return "c";
		case 1:	return "@@";
		case 2:	return "G@";
		case 3:	return "T@";
		case 4:	return "|@";
		case 5:	return "@";
		case 6:	return "C";
		case 7:	return "k";
		default:	return "";
	}
}

/**
 * @fn std::string BaseYiGua::getKin(WuXing lc, WuXing rc)
 * @brief  H˪ܤۤA
 * 
 * @param lc 
 * @param rc n
 * 
 * @return Ǧ^˪A
 */
std::string BaseYiGua::getKin(WuXing lc, WuXing rc)
{
	WWuXing w5 = WWuXing::initWWuXing();
	
	std::string kin = w5.relation(lc,rc);

	if (kin == "P")		return "S";
	if (kin == "ͧ")		return "";
	if (kin == "g")		return "x";
	if (kin == "ګg")		return "d]";
	if (kin == "ڥ")		return "l]";
}

/**
 * @fn boost::array<std::string,6> BaseYiGua::getSixKin(Gua upGua, Gua downGua)
 * @brief  o˪A(HBaseYiGua󬰤¦)
 * 
 * @param upGua		W
 * @param downGua	U
 * 
 * @return Ǧ^Ҿ֦˰}C
 */
boost::array<std::string,6> BaseYiGua::getSixKin(Gua upGua, Gua downGua)
{
	boost::array<std::string, 6> kin6;

	WWuXing w5 = WWuXing::initWWuXing();
	WZhi wz = WZhi::initWZhi();
	BaGua gua8 = BaGua::initBaGua();

	WuXing lc = w5.getWuXing(gua8.getGua(_belongToGua).getWuXing());	
	// W
	for (size_t i = 0; i < 3; i++)
	{		
		WuXing rc = w5.getWuXing(wz.getZhi(upGua.getUpGanZhi().at(i).substr(2,2)).getWuXing());
		kin6.at(i) = getKin(lc,rc);
	}
	
	// U
	for (size_t i = 0; i < 3; i++)
	{
		WuXing rc = w5.getWuXing(wz.getZhi(downGua.getDownGanZhi().at(i).substr(2,2)).getWuXing());
		kin6.at(i+3) = getKin(lc,rc);
	}		
	return kin6;
}

/**
 * @fn boost::array<std::string, 6> BaseYiGua::getSixBeast(Gan dayGan)
 * @brief  o~(Hz~)
 * 
 * @param dayGan z
 * 
 * @return Ǧ^Ҿ֦~}C
 */
boost::array<std::string, 6> BaseYiGua::getSixBeast(Gan dayGan)
{
	boost::array<std::string, 6> sixBeast = {"ȪZ","ժ","fD","ĳ","","Cs"};

	std::string gan = dayGan.getName();	
	if (gan == "" || gan == "B")	
		std::rotate(sixBeast.begin(),sixBeast.end()-1,sixBeast.end());
	if (gan == "")
		std::rotate(sixBeast.begin(),sixBeast.end()-2,sixBeast.end());
	if (gan == "v")
		std::rotate(sixBeast.begin(),sixBeast.end()-3,sixBeast.end());
	if (gan == "" || gan == "")
		std::rotate(sixBeast.begin(),sixBeast.end()-4,sixBeast.end());
	if (gan == "" || gan == "")
		std::rotate(sixBeast.begin(),sixBeast.end()-5,sixBeast.end());
	
	return sixBeast;
}

/**
 * @fn std::vector<std::string> BaseYiGua::getHideGod()
 * @brief  o(ê - D˼Ƥ)
 * 
 * @param (SѼ)
 * 
 * @return Ǧ^˪AVector
 */
std::vector<std::string> BaseYiGua::getHideGod()
{	
	std::vector<std::string> kin;
	kin.reserve(5);
	kin.push_back("");
	kin.push_back("S");
	kin.push_back("l]");
	kin.push_back("d]");
	kin.push_back("x");
	
	std::vector<std::string> destVec;	///< unique elements
	
	// oƪ
	boost::array<std::string, 6> srcArray = getSixKin(_upGua, _downGua);
	std::sort(srcArray.begin(),srcArray.end());
	std::unique_copy(srcArray.begin(),srcArray.end(),back_inserter(destVec));	

	/*
	std::cout << "destVec.size() = " << destVec.size() << std::endl;
	for(size_t i = 0; i < destVec.size(); i++)
		std::cout << i << " = " << destVec.at(i) << std::endl;
	*/

	if (destVec.size() < 5)
	{		
		// oc
		BaGua gua8 = BaGua::initBaGua();
		Gua orig = gua8.getGua(_belongToGua);
		boost::array<std::string,6> origGua = getSixKin(orig,orig);
		
		// o
		std::vector<std::string>::iterator vp;
		for (size_t i = 0; i < destVec.size(); i++)
			kin.erase(std::remove(kin.begin(),kin.end(),destVec.at(i)),kin.end());				
	}
	else
		kin.clear();
	return kin;
}
